<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Change Password</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
*{box-sizing:border-box}
body{
  margin:0;
  font-family:'Poppins',sans-serif;
  background:linear-gradient(135deg,#6a11cb,#8e2de2);
  min-height:100vh;
  overflow:hidden;
}

/* PARTICLE */
canvas{
  position:fixed;
  inset:0;
  z-index:1;
  pointer-events:none;
}

/* PAGE */
.page{
  position:relative;
  z-index:2;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:40px;
}

/* WRAPPER */
.wrapper{
  width:100%;
  max-width:520px;
  background:#fff;
  border-radius:22px;
  box-shadow:0 40px 90px rgba(0,0,0,.35);
  overflow:hidden;
}

/* CARD */
.card{
  background:linear-gradient(135deg,#7b4ce6,#5f2eea);
  color:#fff;
  padding:46px 40px;
}

/* HEADER */
h2{
  text-align:center;
  margin-bottom:28px;
  font-weight:600;
}

/* INPUT */
.input{
  width:100%;
  height:46px;
  border:none;
  border-radius:14px;
  padding:0 15px;
  margin-bottom:16px;
  background:rgba(255,255,255,.22);
  color:#fff;
}
.input::placeholder{color:#e6ddff}
.input:focus{
  outline:none;
  box-shadow:0 0 0 3px rgba(255,204,0,.45);
}

/* PASSWORD EYE */
.password-wrap{
  position:relative;
}
.eye{
  position:absolute;
  right:14px;
  top:50%;
  transform:translateY(-50%);
  cursor:pointer;
  font-size:18px;
  opacity:.85;
}

/* BUTTON */
button{
  width:100%;
  height:48px;
  border:none;
  border-radius:14px;
  background:#ffcc00;
  color:#000;
  font-weight:600;
  cursor:pointer;
  transition:.3s;
  margin-top:10px;
}
button:hover{transform:translateY(-2px)}

/* MOBILE */
@media(max-width:480px){
  body{overflow:auto}
  .page{padding:20px}
  .card{padding:32px 20px}
  h2{font-size:22px}
}
</style>
</head>

<body>

<canvas id="fx"></canvas>

<div class="page">
  <div class="wrapper">
    <div class="card">

      <h2>Change Password</h2>

      <?= form_open('', 'class="actionForm" data-redirect="user"') ?>

        <div class="password-wrap">
          <input class="input" type="password" id="password"
            name="password" placeholder="New Password" required>
          <span class="eye" onclick="toggle('password',this)">👁️</span>
        </div>

        <div class="password-wrap">
          <input class="input" type="password" id="c_password"
            name="c_password" placeholder="Confirm Password" required>
          <span class="eye" onclick="toggle('c_password',this)">👁️</span>
        </div>

        <button type="submit">CHANGE PASSWORD</button>

      <?= form_close(); ?>

    </div>
  </div>
</div>

<script>
/* PARTICLE EFFECT */
const c=document.getElementById("fx"),x=c.getContext("2d");
let w,h,p=[];
function resize(){w=c.width=innerWidth;h=c.height=innerHeight}
resize();addEventListener("resize",resize);

function add(x0,y0){p.push({x:x0,y:y0,l:60})}
addEventListener("mousemove",e=>add(e.x,e.y));
addEventListener("touchmove",e=>{
 let t=e.touches[0];add(t.clientX,t.clientY)
});

function draw(){
 x.clearRect(0,0,w,h);
 p.forEach((a,i)=>{
  a.l--;
  p.slice(i+1).forEach(b=>{
   let d=Math.hypot(a.x-b.x,a.y-b.y);
   if(d<120){
    x.strokeStyle=`rgba(255,255,255,${.15*(1-d/120)})`;
    x.beginPath();x.moveTo(a.x,a.y);x.lineTo(b.x,b.y);x.stroke();
   }
  });
 });
 p=p.filter(a=>a.l>0);
 requestAnimationFrame(draw);
}
draw();

/* PASSWORD TOGGLE */
function toggle(id,el){
  const i=document.getElementById(id);
  if(i.type==="password"){
    i.type="text";el.textContent="🙈";
  }else{
    i.type="password";el.textContent="👁️";
  }
}
</script>

</body>
</html>
